

let spewterMap = new WeakMap()
EntityEvents.death('blue_skies:spewter', event => {
    if (spewterMap['crusher'] == undefined) {
        spewterMap['crusher'] = 1
    } else {
        spewterMap['crusher']++
    }
    if (spewterMap['crusher'] >= 4) {
        spewterMap['crusher'] = 4
    }
})


EntityEvents.death('blue_skies:ent_wall', event => {

    let box = AABB.of(
        event.entity.x - 5,
        event.entity.y - 5,
        event.entity.z - 5,
        event.entity.x + 5,
        event.entity.y + 5,
        event.entity.z + 5
    )

        
    let entities = event.level.getEntitiesWithin(box)
        entities.forEach(e => {
            let uuid = e.uuid
            let amp = spewterMap['crusher']
            if (amp == undefined || amp == 0) {
                return
            }
            if (e.type == 'blue_skies:starlit_crusher') {
                Utils.server.runCommandSilent(`/effect give ${uuid} minecraft:weakness 30 0 true`)
                Utils.server.runCommandSilent(`/effect give ${uuid} attributeslib:sundering 30 ${amp} true`)
            } else if (e.player) {
                Utils.server.runCommandSilent(`/effect give ${uuid} minecraft:strength 30 ${amp-2} true`)
            }


        })
        spewterMap['crusher'] = 0
})

//blue_skies:snow_owl


let blue_skies_spells = {
    'blue_skies:snow_owl': ['icicle', 'frost_step', 'cone_of_cold'],
    'blue_skies:spewter': ['poison_splash', 'acid_orb', 'firefly_swarm'],
    'blue_skies:ent_wall': ['gust'],
}


EntityEvents.hurt('blue_skies:snow_owl', event => {
    if (!event.source.player) return
    let target = event.source.player
    let chance = Math.random()
    if (chance > 0.20) return
    if (target == null) return
    let allspells = blue_skies_spells['blue_skies:snow_owl']
    randomCast(event.entity, allspells, target, 3)
})

EntityEvents.hurt('blue_skies:spewter', event => {
    if (!event.source.player) return
    let target = event.source.player
    let chance = Math.random()
    if (chance > 0.50) return
    let allspells = blue_skies_spells['blue_skies:spewter']
    randomCast(event.entity, allspells, target, 3)
})

/**
 * EntityEvents.death('blue_skies:spewter', event => {
    let x = event.entity.x
    let y = event.entity.y
    let z = event.entity.z
    Utils.server.scheduleInTicks(15*20, e => {
        let box = AABB.of(
            x - 15,
            y - 15,
            z - 15,
            x + 15,
            y + 15,
            z + 15
        )
        let entities = event.level.getEntitiesWithin(box).filter(e => e.type == 'blue_skies:starlit_crusher')
        if (entities.length == 0) return
        let spewter = event.level.createEntity('blue_skies:spewter')
        spewter.setPos(x, y, z)
        spewter.spawn()
    })
})
 * 
 * 
 */


EntityEvents.hurt('blue_skies:ent_wall', event => {
    if (!event.source.player) return
    let target = event.source.player
    let chance = Math.random()
    if (chance > 0.20) return
    let allspells = blue_skies_spells['blue_skies:ent_wall']
    randomCast(event.entity, allspells, target, 3)
})